#include <proto/intuition.h>
#include <proto/graphics.h>
#include <proto/exec.h>

#define rp window->RPort

         struct Screen *screen=NULL;
         struct Window *window=NULL;
         struct IntuiMessage *message;
         ULONG class;

         int sirka=320,vyska=256;
         int x,y,z;

void main()
{
         //wb screen struktura je tu len koli zisteniu sirky a vysky obrazovky
         screen=(struct Screen *)OpenWorkBench();
         if(screen) {
         sirka=screen->Width;
         vyska=screen->Height;
         }

         // otvorenie okna
         window=OpenWindowTags(NULL,
         WA_Left,         0,
         WA_Top,          0,
         WA_Width,        sirka,
         WA_Height,       vyska,
         WA_MinWidth,     64,
         WA_MinHeight,    64,
         WA_Title,        "Okno",
         WA_ScreenTitle,  "Stvorec - screen title pre nase okno",
         WA_SimpleRefresh,TRUE,
         WA_Flags,        WFLG_ACTIVATE|WFLG_RMBTRAP|WFLG_DRAGBAR|
                          WFLG_CLOSEGADGET|WFLG_DEPTHGADGET|WFLG_SIZEGADGET,
         WA_IDCMP,        IDCMP_CLOSEWINDOW|IDCMP_REFRESHWINDOW,
         TAG_DONE);
         if(!window) goto Koniec;



Redraw:
         //velkost obsahu okna
         sirka=window->Width-window->BorderLeft-window->BorderRight;
         vyska=window->Height-window->BorderTop-window->BorderBottom;

         //stred obsahu okna
         x=window->BorderLeft+sirka/2;
         y=window->BorderTop+vyska/2;

         //velkost stvorca = polovicka kratsej strany okna
         if(x<y) z=x/2; else z=y/2;

         //vymazanie obsahu okna
         EraseRect(rp,window->BorderLeft,window->BorderTop,sirka+window->BorderLeft-1,vyska+window->BorderTop-1);

         //nastavenie farby
         SetAPen(rp,1);

         //vykreslenie stvorca o velkosti "z" v strede okna
         Move(rp,x-z,y-z);
         Draw(rp,x+z,y-z);
         Draw(rp,x+z,y+z);
         Draw(rp,x-z,y+z);
         Draw(rp,x-z,y-z);



Cyklus:
         //test IDCMP flagov, v nasom pripade REFRESH okna a CLOSE tlacitko
         if(message=(struct IntuiMessage *) GetMsg(window->UserPort)) {
         class=message->Class;
         ReplyMsg((struct Message *)message);
         switch(class) {
         case CLOSEWINDOW: goto Koniec; break;
         case REFRESHWINDOW: goto Redraw; break;
         }}

         WaitPort(window->UserPort);  // pokial sa nic nedeje, da sa do sleep modu
         goto Cyklus;



         //ukoncenie programu, zatvorenie okna
Koniec:
         if(window) CloseWindow(window);
}

