;APS00000000000000000000378C00000000000000000000000000000000000000000000000000000000
					     ;********************************
					     ;** playMod v1.x by Lisiak/CDS **
					     ;********************************
	                                     ;date: 1 March 2024

		SECTION	musicRoutine, CODE_C ;establishing a code section

START 



    *** MiniWrapper by Photon ***

Start:	move.l 4.w,a6			;Exec library base address in a6
	sub.l a4,a4
	btst #0,297(a6)			;68000 CPU?
	beq.s .yes68k
	lea .GetVBR(PC),a5		;else fetch vector base address to a4:
	jsr -30(a6)			;enter Supervisor mode

    *--- save view+coppers ---*

.yes68k:lea .GfxLib(PC),a1		;either way return to here and open
	jsr -408(a6)			;graphics library
	tst.l d0			;if not OK,
	beq.s .quit			;exit program.
	move.l d0,a5			;a5=gfxbase

	move.l a5,a6
	move.l 34(a6),-(sp)
	sub.l a1,a1			;blank screen to trigger screen switch
	jsr -222(a6)			;on Amigas with graphics cards

    *--- save int+dma ---*

	lea $dff000,a6
	bsr.s WaitEOF			;wait out the current frame
	move.l $1c(a6),-(sp)		;save intena+intreq
	move.w 2(a6),-(sp)		;and dma
	move.l $6c(a4),-(sp)		;and also the VB int vector for sport.
	bsr.s AllOff			;turn off all interrupts+DMA

    *--- call demo ---*

	movem.l a4-a6,-(sp)
;	bsr.w	Demo			;call our demo \o/
	bsr.w	programCycle		;call our demo \o/
	movem.l (sp)+,a4-a6

    *--- restore all ---*

	bsr.s WaitEOF			;wait out the demo's last frame
	bsr.s AllOff			;turn off all interrupts+DMA
	move.l (sp)+,$6c(a4)		;restore VB vector
	move.l 38(a5),$80(a6)		;and copper pointers
	move.l 50(a5),$84(a6)
	addq.w #1,d2			;$7fff->$8000 = master enable bit
	or.w d2,(sp)
	move.w (sp)+,$96(a6)		;restore DMA
	or.w d2,(sp)
	move.w (sp)+,$9a(a6)		;restore interrupt mask
	or.w (sp)+,d2
	bsr.s IntReqD2			;restore interrupt requests

	move.l a5,a6
	move.l (sp)+,a1
	jsr -222(a6)			;restore OS screen

    *--- close lib+exit ---*

	move.l a6,a1			;close graphics library
	move.l 4.w,a6
	jsr -414(a6)
.quit:	moveq #0,d0			;clear error return code to OS
	rts				;back to AmigaDOS/Workbench.

.GetVBR:dc.w $4e7a,$c801		;hex for "movec VBR,a4"
	rte				;return from Supervisor mode

.GfxLib:dc.b "graphics.library",0,0

WaitEOF:				;wait for end of frame
	bsr.s WaitBlitter
	move.w #$138,d0
WaitRaster:				;Wait for scanline d0. Trashes d1.
.l:	move.l 4(a6),d1
	lsr.l #1,d1
	lsr.w #7,d1
	cmp.w d0,d1
	bne.s .l			;wait until it matches (eq)
	rts

AllOff:
	move.w #$7fff,d2		;clear all bits
;	move.w d2,$96(a6)		;in DMACON,
	move.w d2,$9a(a6)		;INTENA,
IntReqD2:
	move.w d2,$9c(a6)		;and INTREQ
	move.w d2,$9c(a6)		;twice for A4000 compatibility
	rts

WaitBlitter:				;wait until blitter is finished
	tst.w (a6)			;for compatibility with A1000
.loop:	btst #6,2(a6)
	bne.s .loop
	rts



;program
;	bsr	playMod


program

*** key press test ***
		btst	#3,$bfed01 ;level 2 request from keyboard?
		beq	unpressed  ;no, jump here

		move.b	$bfec01,d0
		not.b	d0
		ror.b	#1,d0
;		cmp.b	#$40,d0

		bset	#6,$bfee01 ;start ciaa
		bclr	#6,$bfee01 ;stop ciaa

		cmp.b	#$4c,d0 ;up arrow key
		bne	tstDownArrow

;		lea	numberMod(pc),a0
		lea	positionMods(pc),a0
		lea	mods(pc),a1

		cmp.w	#0,a6
		bne	autoPreviousMod
		add.w	#16,a6 ;16-4=12

autoPreviousMod	subq.w	#4,a6
		add.l	0(a0,a6.w),a1
;;		bra	demo2
;		bsr	demo2
		bsr	playNextMod



tstDownArrow	cmp.b	#$4d,d0 ;down arrow key
		bne	tstEcs

autoNextMod
;		lea	numberMod(pc),a0
		lea	positionMods(pc),a0
		lea	mods(pc),a1

		addq.w	#4,a6
		cmp.w	#16,a6
		bne	autoNextMod0
		sub.w	a6,a6
autoNextMod0	add.l	0(a0,a6.w),a1
;;		bra	demo2
;		bsr	demo2
		bsr	playNextMod

tstEcs		cmp.b	#$45,d0 ;ESC key
		beq	playModEnd



unpressed	btst	#$6,$bfe001 ;test LMB button
		bne	programContinue


playModEnd	moveq	#0,d0
		move.w	#$f,$dff096

;		move.l	4.w,a6		;baze execu do a6
                                        ;_LVOPermit=-138 ;spusteni multitask
;		jsr	-138(a6)	;
		rts


programCycle
                                 ;for song in MOD:
		bsr	playMod  ;1st 1/2 cycle in playMOD -MOD pointer SMP etc
;nextCycle
		bra	program  ;program in this code



*** start primary cyrcle for MOD and program ****************************

programContinue	bsr	playMod2 ;2nd 1/2 cycle and other whole cycle-
                                 ;-in playMOD, count = MOD tempo = 1-20h
;		bra	nextCycle
		bra	program  ;program in this code

*** end primary cyrcle for MOD and program ******************************



     include "DH1:ASM programovani3/playMod146playMod.S"


